package fm.qingting.demo;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.TabLayout;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import com.bumptech.glide.Glide;

import java.util.List;

import fm.qingting.qtsdk.QTException;
import fm.qingting.qtsdk.QTSDK;
import fm.qingting.qtsdk.callbacks.QTCallback;
import fm.qingting.qtsdk.entity.PlayHistory;
import fm.qingting.qtsdk.entity.SimpleChannel;

import static android.widget.Toast.LENGTH_SHORT;

/**
 * Created by lee on 2018/1/23.
 */

public class UserInfoActivity extends AppCompatActivity {
    EditText mEditText;
    Button mButton;
    Button mButton1;
    TabLayout mTabLayout;
    RecyclerView mRecyclerView;
    SimpleAdapter listAdapter;
    SimpleAdapter historyListAdapter;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_list);
        mEditText = findViewById(R.id.et_search);
        mButton = findViewById(R.id.bt_search);
        mButton.setText("收藏");
        mButton1 = findViewById(R.id.bt_cancel);
        mButton1.setVisibility(View.VISIBLE);
        mEditText.setHint("请输入专辑id");
        findViewById(R.id.ll_search).setVisibility(View.VISIBLE);
        mTabLayout = findViewById(R.id.tab);
        mRecyclerView = findViewById(R.id.list);
        listAdapter = new SimpleAdapter<SimpleChannel>() {
            @Override
            public void bindData(SimpleHolder holder, final SimpleChannel object) {
                holder.mTextView.setText(object.getTitle());
                Glide.with(holder.itemView.getContext()).load(object.getThumb()).into(holder.mImageView);
                holder.mLinearLayout.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        switch (object.getType()) {
                            case "channel_live":
                                Intent intent = new Intent(v.getContext(), RadioDetailsListActivity.class);
                                intent.putExtra(DetailsActivity.CHANNEL_ID, object.getId());
                                v.getContext().startActivity(intent);
                                break;
                            case "channel_ondemand":
                                intent = new Intent(v.getContext(), DetailsActivity.class);
                                intent.putExtra(DetailsActivity.CHANNEL_ID, object.getChannelId());
                                v.getContext().startActivity(intent);
                                break;
                            case "program_ondemand":
                                intent = new Intent(v.getContext(), DetailsActivity.class);
                                intent.putExtra(DetailsActivity.CHANNEL_ID, object.getChannelId());
                                v.getContext().startActivity(intent);
                                break;
                        }
                    }
                });
            }
        };
        historyListAdapter = new SimpleAdapter<PlayHistory>() {
            @Override
            public void bindData(SimpleHolder holder, final PlayHistory object) {
                holder.mTextView.setText("类型：" + object.getChannelType() + "专辑id：" + object.getChannelId() + " 节目id:" + object.getProgramId());
                holder.mLinearLayout.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        switch (object.getChannelType()) {
                            case "channel_live":
                                Intent intent = new Intent(v.getContext(), RadioDetailsListActivity.class);
                                intent.putExtra(DetailsActivity.CHANNEL_ID, object.getChannelId());
                                v.getContext().startActivity(intent);
                                break;
                            case "channel_ondemand":
                                intent = new Intent(v.getContext(), DetailsActivity.class);
                                intent.putExtra(DetailsActivity.CHANNEL_ID, object.getChannelId());
                                v.getContext().startActivity(intent);
                                break;
                        }
                    }
                });
            }
        };
        mRecyclerView.setLayoutManager(new LinearLayoutManager(getBaseContext()));
        mRecyclerView.setAdapter(listAdapter);
        TabLayout.Tab tab = mTabLayout.newTab();
        tab.setText("收藏");
        tab.setTag(0);
        mTabLayout.addTab(tab);
        tab = mTabLayout.newTab();
        tab.setText("播放历史");
        tab.setTag(1);
        mTabLayout.addTab(tab);
        mTabLayout.addOnTabSelectedListener(new TabLayout.OnTabSelectedListener() {
            @Override
            public void onTabSelected(TabLayout.Tab tab) {
                if (Integer.parseInt(String.valueOf(tab.getTag())) == 0) {
                    requestCollectList();
                    findViewById(R.id.ll_search).setVisibility(View.VISIBLE);
                } else {
                    requestHistoryList();
                    findViewById(R.id.ll_search).setVisibility(View.INVISIBLE);
                }
            }

            @Override
            public void onTabUnselected(TabLayout.Tab tab) {

            }

            @Override
            public void onTabReselected(TabLayout.Tab tab) {

            }
        });
        mButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (TextUtils.isEmpty(mEditText.getText().toString())) {
                    Toast.makeText(getBaseContext(), "专辑id不能为空", Toast.LENGTH_SHORT);
                    return;
                }
                QTSDK.addFavChannel(Integer.parseInt(mEditText.getText().toString()), new QTCallback<Void>() {
                    @Override
                    public void done(Void result, QTException e) {
                        if (e == null) {
                            Toast.makeText(getBaseContext(), "收藏成功", Toast.LENGTH_SHORT);
                            requestCollectList();
                        } else {
                            Toast.makeText(getBaseContext(), "收藏失败:" + e.getMessage(), Toast.LENGTH_SHORT);
                        }
                    }
                });

            }
        });
        mButton1.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (TextUtils.isEmpty(mEditText.getText().toString())) {
                    Toast.makeText(getBaseContext(), "专辑id不能为空", Toast.LENGTH_SHORT);
                    return;
                }
                QTSDK.deleteFavChannel(Integer.parseInt(mEditText.getText().toString()), new QTCallback<Void>() {
                    @Override
                    public void done(Void result, QTException e) {
                        if (e == null) {
                            Toast.makeText(getBaseContext(), "取消收藏成功", Toast.LENGTH_SHORT);
                            requestCollectList();
                        } else {
                            Toast.makeText(getBaseContext(), "取消收藏失败:" + e.getMessage(), Toast.LENGTH_SHORT);
                        }
                    }
                });
            }
        });
        requestCollectList();
    }

    private void requestCollectList() {
        mRecyclerView.setAdapter(listAdapter);
        QTSDK.requestFavChannel(new QTCallback<List<SimpleChannel>>() {
            @Override
            public void done(List<SimpleChannel> result, QTException e) {
                if (e == null) {
                    if (result != null) {
                        listAdapter.items = result;
                        listAdapter.notifyDataSetChanged();
                    }
                } else {
                    Toast.makeText(getBaseContext(), e.getMessage(), LENGTH_SHORT).show();
                }
            }
        });
    }

    private void requestHistoryList() {
        mRecyclerView.setAdapter(historyListAdapter);
        QTSDK.requestPlayHistory(new QTCallback<List<PlayHistory>>() {
            @Override
            public void done(List<PlayHistory> result, QTException e) {
                if (e == null) {
                    if (result != null) {
                        historyListAdapter.items = result;
                        historyListAdapter.notifyDataSetChanged();
                    }
                } else {
                    Toast.makeText(getBaseContext(), e.getMessage(), LENGTH_SHORT).show();
                }
            }

        });
    }
}
